import argparse
import logging

from crypta.dmp.yandex.bin.send_report_mail.lib import report_processor
from crypta.lib.python import yaml_config
from crypta.lib.python.logging import logging_helpers


logger = logging.getLogger(__name__)


def parse_args():
    parser = argparse.ArgumentParser(description="Send report to dmp")
    parser.add_argument("--config", help="Path to config", required=True, type=yaml_config.load)
    return parser.parse_args()


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())

    args = parse_args()
    logger.info(args)

    report_processor.process(args.config, logger)

    logger.info("Completed successfully")
