import argparse
import datetime
import logging

from crypta.dmp.yandex.bin.common.python import config_fields
from crypta.dmp.yandex.bin.send_statistics_mail.lib import statistics_processor
from crypta.lib.python import yaml_config
from crypta.lib.python.logging import logging_helpers
from crypta.lib.python.smtp.text_mail_sender import TextMailSender
from crypta.lib.python.yt import yt_helpers


logger = logging.getLogger(__name__)


def parse_args():
    parser = argparse.ArgumentParser(description="Sends statistics mails about dmp's meta")
    parser.add_argument("--config", help="Path to config", required=True, type=yaml_config.load)
    return parser.parse_args()


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())

    args = parse_args()
    logger.info(args)

    config = args.config
    yt_client = yt_helpers.get_yt_client(config[config_fields.YT_PROXY], config[config_fields.YT_POOL])
    mail_sender = TextMailSender(
        host=config[config_fields.SMTP_HOST],
        port=config[config_fields.SMTP_PORT],
        default_from_addr=config[config_fields.SMTP_EMAIL_FROM],
        default_to_addrs=config[config_fields.STATISTICS_EMAILS],
        default_cc=config[config_fields.STATISTICS_EMAILS_CC],
        default_bcc=config[config_fields.STATISTICS_EMAILS_BCC],
        dry_run=not config[config_fields.SEND_STATISTICS_EMAILS]
    )

    statistics_processor.process(
        mail_sender=mail_sender,
        yt_client=yt_client,
        statistics_dir=config[config_fields.STATISTICS_DIR],
        processed_statistics_dir=config[config_fields.PROCESSED_STATISTICS_DIR],
        statistics_ttl=datetime.timedelta(days=config[config_fields.STATISTICS_TTL_DAYS]),
        dmp_login=config[config_fields.DMP_LOGIN],
    )

    logger.info("Completed successfully")
