import logging

import yt.wrapper as yt

from crypta.dmp.yandex.bin.send_statistics_mail.lib import message_generator
from crypta.lib.python.yt import yt_helpers


logger = logging.getLogger(__name__)


def process(mail_sender, yt_client, statistics_dir, processed_statistics_dir, statistics_ttl, dmp_login):
    for table_name in yt_client.list(statistics_dir, absolute=False):
        source = yt.ypath_join(statistics_dir, table_name)
        destination = yt.ypath_join(processed_statistics_dir, table_name)
        logging.info("Process %s", source)

        with yt_client.Transaction():
            statistics = list(yt_client.read_table(source))
            yt_client.move(source, destination, force=True, recursive=True)

            if statistics:
                subject, body, attachments = message_generator.generate(table_name, statistics, dmp_login)
                mail_sender.send(subject, body, attachments=attachments)

        yt_helpers.set_ttl(destination, statistics_ttl, yt_client=yt_client)
