#include <crypta/dmp/yandex/bin/update_segments/lib/update_segments_job.h>
#include <crypta/dmp/yandex/bin/common/config_fields.h>

#include <crypta/lib/native/yt/job/runner.h>

#include <library/cpp/yaml/as/tstring.h>

using namespace NCrypta;
using namespace NDmp;

namespace {
    TUpdateSegmentsJob::TConfig ParseConfig(const YAML::Node& yaml) {
        using namespace NConfigFields;

        TUpdateSegmentsJob::TConfig config;
        config.YtProxy = yaml[YT_PROXY].as<TString>();
        config.YtPool = yaml[YT_POOL].as<TString>();
        config.InputDir = yaml[PARSED_SEGMENTS_DIR].as<NYT::TYPath>();
        config.MetaState = yaml[META_TABLE].as<NYT::TYPath>();
        config.BindingsState = yaml[EXT_ID_BINDINGS_TABLE].as<NYT::TYPath>();
        config.StatisticsOutputDir = yaml[STATISTICS_DIR].as<NYT::TYPath>();
        config.QuarantineDir = yaml[QUARANTINE_DIR].as<NYT::TYPath>();
        config.ShouldDropInput = yaml[SHOULD_DROP_INPUT].as<bool>();
        config.InactiveSegmentsTtl = yaml[INACTIVE_SEGMENTS_TTL].as<time_t>();
        config.BindingsTtl = yaml[BINDINGS_TTL].as<time_t>();
        return config;
    }
}

int main(int argc, const char** argv) {
    return RunJob<TUpdateSegmentsJob, ParseConfig>(argc, argv);
}
