#pragma once

#include <crypta/dmp/common/data/bindings.h>
#include <crypta/lib/native/time/ttl.h>
#include <crypta/lib/native/yt/utils/tables_indexes.h>

#include <mapreduce/yt/interface/client.h>

#include <util/generic/hash_set.h>

namespace NCrypta::NDmp {
    class TUpdateBindingsReducer : public NYT::IReducer<NYT::TNodeReader, NYT::TNodeWriter> {
    public:
        enum class EInputTables {
            FreshBindings,
            StateBindings
        };

        using TInputIndexes = TTablesIndexes<EInputTables>;

        TUpdateBindingsReducer() = default;
        TUpdateBindingsReducer(const TInputIndexes& inputIndexes, time_t bindingsTtl, const THashSet<ui64>& disabledSegments, const THashSet<ui64>& deletedSegments);

        void Do(TReader* reader, TWriter* writer) override;

        Y_SAVELOAD_JOB(InputIndexes, BindingsTtl, DisabledSegments, DeletedSegments);

    private:
        void Read(TReader* reader, TMaybe<TBindings>& fresh, TMaybe<TBindings>& state) const;
        void RestoreDisabled(TBindings& fresh, const TBindings& state) const;
        void CleanupDeleted(TBindings& state) const;
        void WriteBindings(TWriter* writer, const TBindings& bindings) const;

        TInputIndexes InputIndexes;
        TTtl BindingsTtl;
        THashSet<ui64> DisabledSegments;
        THashSet<ui64> DeletedSegments;
    };
}
