#pragma once

#include <crypta/dmp/common/data/segment.h>
#include <crypta/dmp/yandex/bin/common/segment_action.h>
#include <crypta/lib/native/time/ttl.h>
#include <crypta/lib/native/yt/utils/tables_indexes.h>

#include <mapreduce/yt/interface/client.h>

using namespace NCrypta;

namespace NCrypta::NDmp {
    class TUpdateMetaReducer : public NYT::IReducer<NYT::TNodeReader, NYT::TNodeWriter> {
    public:
        enum class EInputTables {
            FreshMeta,
            StateMeta
        };

        enum class EOutputTables {
            Meta,
            Statistics,
            Errors
        };

        using TInputIndexes = TTablesIndexes<EInputTables>;
        using TOutputIndexes = TTablesIndexes<EOutputTables>;

        TUpdateMetaReducer() = default;
        TUpdateMetaReducer(const TInputIndexes& inputIndexes, const TOutputIndexes& TOutputIndexes, const TMaybe<ui64>& timestamp, time_t inactiveSegmentsTtl);

        void Do(TReader* reader, TWriter* writer) override;

        Y_SAVELOAD_JOB(InputIndexes, OutputIndexes, Timestamp, InactiveSegmentsTtl);

    private:
        void Read(TReader* reader, TMaybe<TSegment>& fresh, TMaybe<TSegment>& state) const;
        bool NeedToDisable(const TMaybe<TSegment>& fresh, const TMaybe<TSegment>& state) const;
        bool NeedToDelete(const TMaybe<TSegment>& fresh, const TMaybe<TSegment>& state) const;
        bool NeedToAdd(const TMaybe<TSegment>& fresh, const TMaybe<TSegment>& state) const;
        bool NeedToUpdate(const TMaybe<TSegment>& fresh, const TMaybe<TSegment>& state) const;
        void Disable(TWriter* writer, TSegment& state) const;
        void Delete(TWriter* writer, TSegment& state) const;
        void Add(TWriter* writer, const TSegment& fresh) const;
        void Update(TWriter* writer, const TSegment& fresh, const TSegment& state) const;
        void WriteMeta(TWriter* writer, const TSegment& segment) const;
        void WriteStatistics(TWriter* writer, const TSegment& segment, ESegmentAction action, const NYT::TNode& diff = NYT::TNode::CreateEntity()) const;

        TInputIndexes InputIndexes;
        TOutputIndexes OutputIndexes;
        TMaybe<ui64> Timestamp;
        TTtl InactiveSegmentsTtl;
    };
}
