#pragma once

#include <crypta/dmp/yandex/bin/common/fresh_segments.h>
#include <crypta/lib/native/log/log.h>

#include <contrib/libs/yaml-cpp/include/yaml-cpp/yaml.h>
#include <mapreduce/yt/interface/client.h>

namespace NCrypta::NDmp {
    class TUpdateSegmentsJob {
    public:
        struct TConfig {
            TString YtProxy;
            TString YtPool;
            NYT::TYPath InputDir;
            NYT::TYPath MetaState;
            NYT::TYPath BindingsState;
            NYT::TYPath StatisticsOutputDir;
            NYT::TYPath QuarantineDir;
            bool ShouldDropInput;
            time_t InactiveSegmentsTtl;
            time_t BindingsTtl;
        };

        TUpdateSegmentsJob(const TConfig& config, NLog::TLogPtr log);

        int Do() const;

    private:
        void UpdateSegments(NYT::ITransactionPtr tx, const TMaybe<TFreshSegments>& freshSegments) const;
        bool UpdateMeta(
            NYT::ITransactionPtr tx,
            TMaybe<ui64>& timestamp,
            const TMaybe<NYT::TYPath>& fresh,
            const TMaybe<NYT::TYPath>& state,
            const NYT::TYPath& output,
            const NYT::TYPath& statistics) const;
        void UpdateBindings(
            NYT::ITransactionPtr tx,
            const TMaybe<NYT::TYPath>& fresh,
            const TMaybe<NYT::TYPath>& state,
            const NYT::TYPath& output,
            const THashSet<ui64>& disabledSegments,
            const THashSet<ui64>& deletedSegments) const;

        const TConfig Config;
        NLog::TLogPtr Log;
    };
}
