import argparse
import logging

from crypta.dmp.yandex.bin.upload_report_to_ftp.lib import uploader
from crypta.lib.python import yaml_config
from crypta.lib.python.logging import logging_helpers


logger = logging.getLogger(__name__)


def parse_args():
    parser = argparse.ArgumentParser(description="Upload dmp reports to FTP")
    parser.add_argument("--config", help="Path to config", required=True, type=yaml_config.load)
    return parser.parse_args()


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())

    args = parse_args()
    logger.info(args)

    uploader.run(args.config, logger)

    logger.info("Completed successfully")
