% Куки-матчинг с DMP

# Куки-матчинг пользователей для партнеров 

Под партнером подразумевается DSP, SSP, DMP или другая организация, с которой необходимо установить соответствие партнерских идентификаторов и идентификаторов Яндекса.

В типичном случае на сайте партнера выставляется некоторая стабильная кука в браузере пользователя. Стабильность понимается в том смысле, что браузер пользователя хранит такую куку длительное, потенциально неограниченное время при условии, что пользователь, например, не чистит куки в браузере.

Под куки-матчингом понимаются механизмы, описанные ниже, благодаря которым на стороне Яндекса соответствие куки партнера и куки Яндекса запоминается и может быть использовано, например, на аукционах на RTB-площадках.

Для настройки куки-матчинга есть два варианта, которые могут использоваться совместно для улучшения покрытия трафика куки-матчингом:

1. куки-матчинг на трафике партнера;
1. куки-матчинг на трафике Яндекса.


#### 1. Куки-матчинг на трафике партнера

В данном варианте куки-матчинг инициирует партнер. В данной схеме ему необходимо встроить ссылку описанного ниже формата (ссылку куки-матчинга) на собственные или подконтрольные партнеру страницы (собственные сайты, сайты партнерских сетей);

Ссылка куки-матчинга возвращает графический пиксель. Формат ссылки:
```
  https://an.yandex.ru/mapuid/<CookieMatchTag>/<ExtUID>[?dump-match=1]
```

Описание параметров:

* ```<CookieMatchTag>``` - уникальный ID tag для RTB-хоста, создаётся в Партнёрском Интерфейсе менеджерами Яндекса и сообщается партнеру;
* ```<ExtUID>``` - идентификатор пользователя (кука), присвоенный партнером; должен быть закодирован методом urlencode;
* ```dump-match=1``` - опциональный параметр, включает режим дебага; при использовании этого параметра от ```an.yandex.ru``` в ответ приходит текст ошибки в виде комментария в HTML-коде.

Результаты вызова ссылки куки-матчинга:

* *200 OK* - если запрос завершился успешно;
* *404 Not found* - если path пустой или неполный, либо CookieMatchTag неизвестен, либо в случае других ошибок;
* *302 Redirect* - редирект в ту же ссылку, чтобы выставить куку Яндекса, если ее раньше не было.

Формирование ссылки куки матчинга происходит следующим образом.

Пользователь заходит на сайт `www.example.com`. Пример строки запроса и передаваемых при этом HTTP-заголовков браузера:
```
GET / HTTP/1.1
User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:40.0)
Host: www.example.com
Accept-Language: ru-RU,ru;q=0.9,en;q=0.8
Accept-Encoding: gzip, deflate
Referer: http://example.com/
Connection: Keep-Alive
```

При обработке запроса сайт решает связать с пользователем идентификатор `<ExtUID> = 1234`. Эти данные предназначены для `<CookieMatchTag> = publishertag`. В этом случае ссылка куки-матчинга будет иметь вид:
```
https://an.yandex.ru/mapuid/publishertag/1234
```

Следует организовать загрузку изображения на странице `www.example.com` по ссылке куки-матчинга, например, из Javascript-а. Для правильной синхронизации идентификаторов ссылка куки-матчинга должна быть вызвана с передачей всех заголовков, в том числе *Cookies* пользователя на домене `an.yandex.ru`. В частности, нельзя использовать [метод fetch](https://developer.mozilla.org/ru/docs/Web/API/Fetch_API/Using_Fetch) с параметрами по умолчанию.

#### 2. Куки-матчинг на трафике Яндекса

В этом варианте куки-матчинг инициирует Яндекс.

Со страниц Яндекса делается запрос на заранее заданный партнерский URL. Сервер партнера возвращает редирект с кодом 302 на ссылку куки-матчинга, аналогичную ссылке из варианта 1.

От партнера требуется:

* предоставить URL для партнерского куки-матчинга;
* реализовать в ответе на данный URL редирект с кодом 302 на ссылку куки-матчинга Яндекса из п.1 (с выставлением `<CookieMatchTag>` и `<ExtUID>`).

Пример ссылки:
```
  https://www.example.com/cm
```

В данной ссылке не указываются CGI-параметры, а при отправке запроса не передается никаких специфичных заголовков.

Механизм работы куки-матчинга здесь следующий.

Допустим, URL партнера задан как `https://www.example.com/cm`. Со страницы на трафике Яндекса делается HTTP-вызов этого URL с некоторой политикой ограничения частоты вызова, чтобы исключить чрезмерную нагрузку на сервер партнера.

Чтобы рассчитать необходимые ресурсы на обработку таких URL, можно считать типичной частотой вызова URL 600 запросов в секунду на пике дневного трафика.

Обработчик URL должен вернуть редирект 302 на ссылку куки-матчинга Яндекса с форматом из п.1. Браузер при получении данного редиректа вызовет ссылку куки-матчинга, автоматически передав нужные заголовки, в том числе *Cookies* для домена Яндекса.

Обработчик ссылки куки-матчинга на стороне Яндекса запишет соответствие идентификатора Яндекса и идентификатора партнера в хранилище, а затем вернет пиксель на страницу в браузере. В случае необходимости будет сначала возвращен еще один редирект с кодом 302 на тот же URL с указанием заголовка Set-Cookie, чтобы выставить в браузере пользователя куку Яндекса, если она еще не была выставлена.

