from binascii import crc32


def calc_cookie_matching_sign(referrer, user_agent, location, ext_uid, cookie_matching_key):
    return crc32((''.join((referrer, user_agent, location, ext_uid, cookie_matching_key)).encode('utf8'))) & 0xffffffff


def test_calc_cookie_matching_sign():
    assert 2664601107 == calc_cookie_matching_sign(
        referrer=u'https://math4-vpr.sdamgia.ru/problem?id=682&print=true',
        user_agent=u'Mozilla/5.0 (Linux; Android 4.2.1; en-us; Nexus 5 Build/JOP40D) AppleWebKit/535.19 (KHTML, like Gecko; googleweblight) Chrome/38.0.1025.166 Mobile Safari/535.19',
        location=u'https://math4-vpr.sdamgia.ru/problem?id=682&print=true',
        ext_uid=u'1Bf5Z8n57C2b9e7s5z4v6l1lZ1',
        cookie_matching_key=u'XOXOXOXOXOXOXOXOXOXOXOXOXOXOXOXO',
    )

    assert 1981923556 == calc_cookie_matching_sign(
        referrer=u'',
        user_agent=u'Mozilla/5.0 (Linux; Android 4.2.1; en-us; Nexus 5 Build/JOP40D) AppleWebKit/535.19 (KHTML, like Gecko; googleweblight) Chrome/38.0.1025.166 Mobile Safari/535.19',
        location=u'',
        ext_uid=u'1Bf5Z8n57C2b9e7s5z4v6l1lZ1',
        cookie_matching_key=u'XOXOXOXOXOXOXOXOXOXOXOXOXOXOXOXO',
    )
