# Передача данных
## Формат 

Передача данных осуществляется по FTP.
Загружаемые файлы должны быть оформлены в виде `tar.gz`-архивов с именами  `segments‑<unixtime>.tar.gz`. Например, `segments‑1450731600.tar.gz`.

Архив должен содержать два файла с именами `meta` и `bindings`. Файлы должны находиться в корне архива, в архиве не должно быть вложенных папок, файлов с другими именами и т. п.


### Файл 'meta'
Содержит информацию обо *всех* сегментах DMP в формате JSON.

Должен иметь кодировку UTF-8.

Файл содержит массив объектов, имеющих следующие поля:

Поле | Описание | Обязательное | Значение
--- | --- | --- | ---
`id` | Уникальный идентификатор сегмента | да | Число от 1 до 1 000 000 000
`title` | Название сегмента, которое будет доступно в интерфейсе рекламных продуктов | да | [_Интернационализованная_](#интернационализация) непустая строка не более 100 символов
`hierarchy` | Иерархия сегмента | да | [_Интернационализованный_](#интернационализация) массив непустых строк в порядке от общего к частному, максимум 7 уровней; если сегмент в корне — то пустой список `[]`
`description` | Описание сегмента, которое будет доступно в интерфейсе рекламных продуктов | нет | [_Интернационализованная_](#интернационализация) непустая строка не более 200 символов
`acl` | Настройки доступа | нет | Массив логинов рекламодателей, которым доступен этот сегмент в рекламных продуктах Яндекса. Логин — это непустая строка формата `<login>@yandex.ru` или просто `<login>`; по умолчанию сегмент доступен всем. Пустой список `[]` — сегмент не доступен никому


#### Интернационализация

Поля, содержащие строки, должны поддерживать интернационализацию (мультиязычность).
Значением таких полей является JSON-словарь. Ключ в словаре — локаль в формате `язык[_ТЕРРИТОРИЯ]`, например:  `en`, `ru`, `en_US`, `ru_RU`. Значение — строка или массив строк на соответствующем языке.
Поддерживаемые языки: `ru`, `en`, `ua`, `tr`.


#### Иерархия
Поле `hierarchy` —  это список узлов дерева сегментов. Используется для наглядного представления и группировки сегментов в интерфейсе рекламных продуктов.
**Узлы иерархии не являются сегментами.**

Например, сегмент с `title="Farmers & gardeners equipment"` и `hierarchy=["Home and garden", "Gardenening and patio"]` будет отображаться следующим образом:

![](resources/hierarchy_example.png)
 
 
<p style="page-break-before: always !important">

#### Пример файла 'meta'

~~~json
[
    {
        "id": 1000,
        "title": {
            "en_US": "Interested in Tires for Cars",
            "ru_RU": "Интересуются шинами легковых автомобилей"
        },
        "hierarchy": {
            "en_US": ["Cars and Motorcycles", "Spare Parts", "Wheels"],
            "ru_RU": ["Авто и мототехника", "Запасные части", "Колеса"]
        },
        "description": {
            "en_US": "Category for ones interested in options for car tires",
            "ru_RU": "Аудитория, которая интересуется различными вариантами шин для легковых автомобилей"
        },
        "acl": ["ads.agency", "ivanov.i.i@yandex.ru"]
    },
    {
        "id": 1001,
        "title": {
            "en_US": "Interested in Tires for Cars",
            "ru_RU": "Интересуются шинами легковых автомобилей"
        },
        "hierarchy": {
            "en_US": ["Cars and Motorcycles", "Spare Parts", "Wheels"],
            "ru_RU": ["Авто и мототехника", "Запасные части", "Колеса"]
        }
    }
]
~~~


### Файл 'bindings'
Содержит информацию о том, в какие сегменты входит каждый пользователь (провязки между сегментами и пользователями).
Строго одна строка на одного пользователя.

Формат строки:

~~~
<user_id>\t<segment_1_id>;<segment_2_id>;...<segments_n_id>
~~~

Указывается `user_id`, затем разделитель `\t`, затем через точку с запятой перечисляются **все** сегменты, в которые этот пользователь входит. В частности, если сегмент указан в строке, а в следующем архиве не будет указан для того же `user_id`, то привязка `user_id` к данному сегменту будет удалена.

`user_id` — идентификатор пользователя, строка (см. документ про cookie matching).



Если у пользователя нет провязок (такая запись используется, чтобы исключить пользователя из всех сегментов), строка заканчивается разделителем `\t`. 

~~~
<user_id>\t
~~~

#### Пример файла 'bindings'

~~~
user_id1	1;2;10;230;1000
user_id2	2;10
user_id3	23;100
user_id4	
user_id5	12
~~~

### Пример архива
Вместе с этим документом партнер получает пример валидного архива.

<br>

## Обработка данных

### Обновление данных
#### Файл 'meta'
Каждый новый загруженный файл замещает предыдущий.

#### Файл 'bindings'

Файл `bindings` должен содержать информацию обо всех пользователях.

Список сегментов каждого пользователя хранится в системе 14 дней после получения, даже если в последующих отгрузках его нет.
Если этот список не изменялся и с прошлой его отгрузки прошло менее 14 дней, пользователя можно не включать в отгрузку.
Настоятельно рекомендуем следовать этому правилу, т. к. это позволяет уменьшить объем отгрузки и увеличить скорость ее обработки.
При работе стоит учитывать время на обработку данных и использовать значение < 14 дней.

### Консистентность данных
Информация в файлах `meta` и `bindings` должна быть согласованной. Если в списке сегментов пользователя указан id сегмента, которого нет в `meta`, — это ошибка. Если в архиве есть хотя бы одна ошибка, все данные из архива считаются неконсистентными и не обрабатываются.

### Размеры сегментов
Ограничения в этом разделе касаются размеров сегментов _после матчинга_.

Таргетирование возможно только на сегменты с размером ≥ 100. Если размер сегмента после куки-матчинга меньше этого значения, он не будет отображаться в интерфейсе рекламных продуктов, кроме Яндекс.Аудиторий.

Если размер сегмента > 50 миллионов, в сегмент будут загружены случайные 50 миллионов пользователей.

### Уведомления об ошибках при обработке
Если присланный архив невалиден (неверные названия, ошибки в формате файлов, несогласованность данных и т. д.), то он не будет обработан. На почту партнера придет письмо с описанием ошибок.  

### Частота  обработки
Отгрузка данных возможна 1 раз в час и реже.
