Автоматическая сборка в TestEnv
===============================

Мы разрабатываемся в Аркадии, поэтому подходы к CI не отличаются от общепринятых. Это значит, что для покоммитного тестирования достаточно правильно структурировать проект с помощью файлов `ya.make`.

Автосборка работает с помощью системы TestEnv. Чтобы добавить тест (по своей роли это триггер для автосборки) нужно следовать [инструкции](https://wiki.yandex-team.ru/testenvironment/razrabotkatestovyaml/), которая сводится к двум простым шагам:

1. Добавить YAML описание в [testenv/jobs/crypta](https://a.yandex-team.ru/arc/trunk/arcadia/testenv/jobs/crypta). В этой папке можно найти много примеров уже работающих тестов.
2. Включить тест в [интерфейсе TestEnv](https://testenv.yandex-team.ru) внутри базы `crypta`. К базе `crypta` может не быть доступа, в таком случае добавить сможет коллега, уже имеющий доступ. При создании теста лучше ограничить в 1 число одновременно запущенных тестов. Параметр origin database указывать не нужно.

После добавления теста на каждое релевантное изменение будет запускаться задача в Sandbox. Для релиза определенной ревизии можно найти Sandbox задачу в [интерфейсе TestEnv](https://testenv.yandex-team.ru).

Если нужный тест не запускается на релевантные коммиты имеет смысл посмотреть в YAML параметры `targets` или `observed_paths`.

Для ускорения сборки по совету devtools@ мы выставляем `build_system` в значение `semi_distbuild`(параллельный запуск на distbuild и локально), а `build_type` в `relwidthdebinfo` (аналогично `release`, но с запуском `assert` и других `-DDEBUG` конструкций). Такая схема позволяет лучше переиспользовать уже собранные ресурсы.

**Рекомендации по описанию YAML тасок**

Мы используем три типа покоммитных фильтров:
* `commit_path_prefixes` - чтобы наши сборки не триггерились на рефакторинги в `util` и прочие нерелевантные коммиты в зависимости нашего кода. Почти всегда в этом фильтре должно быть одно значение - `/trunk/arcadia/crypta/`. Этот фильтр применяется первым. Если он не проходится, коммит сразу отбрасывается.
* `targets` - бинарные цели сборки. Таск будет запущен, если затронет целевой бинарник или какую-то из его зависимостей (но в пределах `commit_path_prefixes`).
* `observed_paths` - файлы и папки, не являющиеся целями сборки. Значение фильтра является регулярным выражением, поэтому рекомендуется использовать вид `^arcadia/crypta/your/path`.

Для пакетов и докерных образов, описанных в виде JSON для `ya package` есть утилита `crypta/util/package_build_deps`. Утилита имеет два режима работы:
1. Ручной запуск `package_build_deps --package package.json` - выводит рекомендованный `filters` для пакета.
2. Режим теста `package_build_deps --package package.json --testenv-task package.yaml [--testenv-task-type TASK_TYPE]`. Утилита сравнивает рекомендованный `filters` с описанным в тестенв таске. Параметр `testenv-task-type` является опциональным и нужен для случаев, когда в YAML файле описывается несколько тасок. [Пример теста](https://a.yandex-team.ru/arc/trunk/arcadia/crypta/utils/graphite_monitor/docker/tests/ya.make).

Чтобы избежать расхождений в зависимостях пакетов и фильтрах сборочных тасок, для каждого пакета, собираемого в TestEnv, должен быть тест, проверяющий соответствие описаний.
