Директива `INCLUDE` в системе сборки ya позволяет вынести в общие файлы повторяющиеся инструкции. Это полезно для фиксирования версий зависимостей и задания глобальных параметров сборки (к примеру, использование ErrorProne).

В *Java* программах и библиотеках стоит добавлять директиву `INCLUDE(${ARCADIA_ROOT}/crypta/lib/inc/java.inc)`. Это позволяет централизованно управлять свойствами сборки (к примеру, `USE_ERROR_PRONE` и `CHECK_JAVA_DEPS`) и управлять версиями с помощью `DEPENDENCY_MANAGEMENT`. Подробнее об этих инструкциях можно почитать в ((/yatool/java/ документации по ya)).

Общие файлы также помогают централизованно управлять версией *YT* в тестах, поэтому имеет смысл использовать .inc файлы:

- для тестов с локальным YT:
```
INCLUDE(${ARCADIA_ROOT}/crypta/lib/inc/local_yt.inc)
```
- для тестов с локальным YQL:
```
INCLUDE(${ARCADIA_ROOT}/crypta/lib/inc/local_yql.inc)
```
Такой способ позволяет упростить глобальное обновление при выходе новой версии YT.
