Сайты
=====================

## Описание
Этот условие позволяет найти тех, кто посещал указанные сайты.

## Источники
* Посещения через Яндекс.Браузера
* Переходы с сервисов Яндекса.

## Что писать в условии
Хосты, ссылки, регулярные выражения

## Подробно
* Ссылка не должна содержать параметры (условия следующие после ``?`` и соединенные амперсандом ``&``) или фрагменты (символы после ``#``). Подробнее про структуру можно почитать в [Википедии](https://ru.wikipedia.org/wiki/URI#Структура_URI)
  <table>
  <tbody>
      <tr>
          <th>Правильно</th><th>Неправильно</th>
      </tr>
      <tr>
          <td><code>ru.wikipedia.org/wiki/URI</code></td>
          <td><code>ru.wikipedia.org/wiki/URI#Структура_URI</code> (есть фрагмент #Структура_URI)</td>
      </tr>
      <tr>
          <td><code>market.yandex.ru/catalog--smartfony/16814639/list</code></td>
          <td><code>market.yandex.ru/catalog--smartfony/16814639/list?hid=91491&onstock=1&local-offers-first=0</code> (есть параметры ?hid=91491&onstock=local-offers-first=0)</t
      </t
  </tbody>
  </table>

* При указании ссылки вида ``example.com/a`` правило будет срабатывать для всех ссылок, имеющий такой префикс, то есть для ``example.com/a/c`` и ``example.com/a/d``, но не ``example.com/b``
* Синтаксис регулярных выражений по ссылкам можно посмотреть в [документации Hyperscan](http://intel.github.io/hyperscan/dev-reference/compilation.html#pattern-support):
    
    **Пример**: раздел сайта налоговой для ИП в Москве и МО имеет вид ``nalog.ru/rn77/ip``, где ``rn77`` отвечает за регион. Чтобы собрать всех пользователей, посещающих такой раздел вне зависимости от региона, можно использовать условие вида ``regexp:nalog.ru/rn\d+/ip``. 
