Слова
=====================

## Описание
Этот тип правила позволяет найти тех, кто видел указанные слова в заголовках или делал поисковые запросы, включающие эти слова. 

  {% note warning %}
    
  В этом типе правила проверяется вхождение слов в заголовок или поисковый запрос, а не полное совпадение введенных слов с заголовком или запросом.
    
  {% endnote %}

## Источники
* Яндекс.Браузер
* Поиск

## Что можно использовать

### Фразы

В этом типе правила можно использовать фразы. В этом случае все слова в строке соединятся через **AND** (логическое **И**), а строки через **OR** (логическое **ИЛИ**). То есть будут найдены пользователи, в заголовках или запросах которых были все слова из хотя бы одной строки.

<img src="https://jing.yandex-team.ru/files/terekhinam/ezgif.com-gif-maker-1.gif" alt="drawing" style="width:500px;"/>


### Логические операторы
  Если нужно задать более сложное условие, используйте:
  * Логические операторы
    * **AND** (логическое «И»)
    * **OR** (логическое «ИЛИ»)
    * **NOT** (логическое отрицание)
  * Скобки **()** для определения порядка применения операторов
  
  По умолчанию порядок применения такой: **NOT** -> **AND** -> **OR** аналогично тому, как в арифметике умножение (**AND**) применяется до сложения (**OR**).
  
  {% note warning %}
    
  Операторы пишутся заглавными буквами.
    
  {% endnote %}

## Объединение условий на разных строках
Разные строки условия неявно объединяются оператором **OR**, поэтому следующие три правила эквивалентны
1.     купить AND настольная AND игра
       купить AND монополия
2.     (купить AND настольная AND игра) OR (купить AND монополия)
3.     купить AND ((настольная AND игра) OR монополия)

## Нормализация
После сохранения все слова будут нормализованы: приведены к нижнему регистру и начальной форме:

<img src="https://jing.yandex-team.ru/files/terekhinam/ezgif.com-video-to-gif%20%2812%29.gif" alt="drawing" style="width:500px;"/>

## Примеры
**Пример 1**: требуется собрать сегмент пользователей, которые интересуются покупкой настольных игр. Тогда правило может выглядеть следующим образом:

    ((игра AND настольный) OR монополия OR диксит OR имаджинариум OR манчкин) AND купить

Это правило сработает для следующих запросов:

    купить настольную игру
    купить настольную игру недорого
    купить монополию

и не сработает для запросов вида:

    монополия онлайн
    магазин настольных игр


Рассмотрим правило вида

    купить AND настольный AND игра
    купить AND настольный AND игра AND недорого
    купить AND настольный AND игра AND абакан

Два последних правила являются избыточными, так как правило

    купить AND настольный AND игра

и так срабатывает для всех запросов, включающих в себя слова (и их формы): "купить", "настольный", "игра", например

    купить настольную игру в абакане
    купить настольную игру
    купить настольную игру недорого в абакане
    купить настольную игру онлайн недорого

**Пример 2**: нужно собрать сегмент пользователей, планирующих покупку автомобиля марки Lexus.
Простейший вариант условия для такой задачи выглядит так:

    lexus OR лексус
Однако с помощью такого условия мы найдем "лишних" пользователей, которые уже владеют Лексусом и ищут для него запчасть или сервис. Чтобы исключить подобные запросы из условия, используем оператор **NOT** и добавим к запросу уточнения, характерные для интересующихся покупкой автомобиля, получим правило

    (
        lexus
        OR лексус
    )
    AND (
        салон
        OR дилер
        OR центр
        OR (тест AND драйв)
        OR цена
        OR купить
        OR обзор
        OR описание
        OR характеристика
        OR комплектация
        OR конфигуратор
        OR отзыв
    )
    AND NOT (
        чинить
        OR ремонтировать
        OR сервисный
        OR ремонт
        OR обслуживание
        OR замена
        OR сервис
        OR клуб
        OR техцентр
        OR то
        OR запчасть
        OR автозапчасть
        OR комплектующий
        OR разборка
        OR покраска
        OR ошибка
        OR фильтр
        OR фонарь
        OR сигнализация
        OR датчик
        OR сидение
        OR колодка
        OR масло
        OR накладка
        OR брызговик
        OR аккумулятор
        OR деталь
        OR фара
        OR амортизатор
        OR бампер
        OR дверь
        OR крыло
        OR магнитола
        OR кондиционер
        OR радиатор
        OR стекло
        OR зеркало
        OR диск
        OR шина
        OR предохранитель
    )
