Выборки для обучения
===

В Лаборатории можно обучить модель классификации, которая позволит получить сегменты пользователей, похожих на положительные (отрацательные) примеры пользователей из обучающей выборки.

На основе полученной модели можно сделать регулярно обновляемые [обучаемые сегменты](https://wiki.yandex-team.ru/crypta/trainablesegments/), которые можно использовать для таргетирования рекламы и внутренней аналитики.

## Как создать выборку

### Источник данных

Обучающая выборка может быть представлена в следующем виде:
- __Таблица__ на ``YT.Hahn``
- __csv-файл__, который можно загрузить в форму при создании выборки для обучения
- __ID сегмента Аудиторий__, куда загружен csv-файл с выборкой. [Требования к файлам](https://yandex.ru/support/audience/file.html) в Яндекс.Аудиториях.

### Формат данных

В таблице / файле должны присутствовать следующие данные:
- Как минимум один из идентификаторов пользователя: ``phone``, ``email``, ``ClientID``, ``IDFA``, ``GAID``, ``UUID``.
    - ``phone``, номер телофона или md5-хэш от него:
        ```
        79995551111
        +79995551111
        89995551111
        f09f2c3d48f31e2a802944ade2e5aec5
        ```
    - ``email``, адрес электронной почты или md5-хэш от нее:
        ```
        example@yandex.ru
        7385287bf0079ffaa7ffe95ac293c63d
        ```
    - ``IDFA``, рекламный идентификатор iOS-устройства.
    - ``GAID``, рекламный идентификатор Android-устройства.
    - ``ClientID``, анонимный идентификатор ClientID (duid), присвоенный Яндекс.Метрикой (см. раздел [getClientID](https://yandex.ru/support/metrica/objects/get-client-id.html)
        справки Яндекс.Метрики).
        ```
        12345678901234567890
        ```
    - ``UUID``, уникальный идентификатор экземпляра приложения, установленного на устройстве (состоит из 32 шестнадцатеричных цифр).
        ```
        A4BBD833A29A9F4C74DBD833A29A9FEC
        ```
- ``target`` отвечает за класс примера, принимает значения 0 (для отрицательных примеров) и 1 (для положительных).
- ``retro_date`` - дата конверсии, дата в которую было известно, что пользователь принадлежит определенному классу.

**Примеры csv-файлов:**
```
phone,email,retro_date,target
79209386842,melanesian@example.com,2021-01-23,1
79216921288,tumbrels@example.com,2020-11-21,0
```

```
phone,retro_date,target
2dca71211faa68cd92dbdb54ae53a646,2020-12-22,0
a96039fabc05c3f208c67b296dd3d847,2021-01-11,1
```

### Ограничения на данные
- Минимум 50 тыс идентификаторов, из которых наименьшего класса (наименьший класс может соответствовать как хорошим конверсиям, так и плохим) должно быть не менее 1 тысячи.

    \* При нарушении этих ограничений рядом с выборкой появляется восклицательный знак с ошибкой.

### Для внешних клиентов
Подробная [документация](https://ext-cachev2-cogent01.cdn.yandex.net/download.cdn.yandex.net/from/yandex.ru/tech/ru/crypta/files/yandex-data-cloud-learning-sample.pdf?lid=1503) по предоставлению данных, которую можно и нужно показывать наружу.

### Про альтернативный формат таблиц, который можно использовать для таблиц на Hahn

В таблице должны быть строковые колонки ``id``, ``id_type``, ``segment_name``, ``retro_date``, со следующими ограничениями:
- ``id_type`` - тип идентификатора ``id``, может принимать значения типов, для которых есть таблицы
[здесь](https://yt.yandex-team.ru/hahn/navigation?path=//home/crypta/public/matching/by_id).
- ``segment_name`` принимает значения __positive__ для положительного примера и  __negative__ для отрицательного примера.
- ``retro_date`` - дата конверсии в формате __YYYY-MM-DD__.

## Описание сегментов

После обучения модели строятся описания следующих сегментов:
- _Исходные_ **положительные** примеры
- _Смоделированные_ **положительные** примеры
- _Исходные_ **отрицательные** примеры
- _Смоделированные_ **отрицательные** примеры

\* Количество пользователей в смоделированных сегментах задается при создании выборки.
