#include <crypta/lib/native/singleton/tagged_singleton.h>

#include <library/cpp/yson/node/node.h>

#include <util/generic/string.h>

namespace NCrypta::NExtFp {
    struct TGetSafeTag {};

    template <typename T>
    static const T GetSafe(const NYT::TNode& node, const TString& key, const T& defaultValue = NCrypta::TaggedSingleton<T, TGetSafeTag>()) {
        const auto& nodeMap = node.AsMap();
        const auto& it = nodeMap.find(key);

        return (it != nodeMap.end()) ? FromString<T>(it->second.As<TString>()) : defaultValue;
    }
}
