#pragma once

#include <yt/yt/core/actions/future.h>

namespace NCrypta::NExtFp {
    template <typename TValue>
    class TUnprocessed {
    public:
        TUnprocessed(TValue&& value)
            : Value(std::move(value))
            , Promise(NYT::NewPromise<void>())
        {
        }

        const TValue& GetValue() const {
            return Value;
        }

        NYT::TFuture<void> GetFuture() const {
            return Promise.ToFuture();
        }

        void SetProcessed() {
            Promise.Set();
        }

    private:
        TValue Value;
        NYT::TPromise<void> Promise;
    };
}
