EXECTEST()

OWNER(
    g:crypta
    g:crypta-ext-fp
)

RUN(
    NAME stable_config
    CWD ${ARCADIA_ROOT}/crypta/ext_fp/delay_line/bundle/templates

    render_and_check_yaml
    --template config.yaml
    --output ${TEST_CASE_ROOT}/output.yaml
    --context '{"environment": "production", "dc": "sas", "fqdn": "localhost"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME testing_config
    CWD ${ARCADIA_ROOT}/crypta/ext_fp/delay_line/bundle/templates

    render_and_check_yaml
    --template config.yaml
    --output ${TEST_CASE_ROOT}/output.yaml
    --context '{"environment": "testing", "dc": "sas", "fqdn": "localhost"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME qa_config
    CWD ${ARCADIA_ROOT}/crypta/ext_fp/delay_line/bundle/templates

    render_and_check_yaml
    --template config.yaml
    --output ${TEST_CASE_ROOT}/output.yaml
    --context '{"environment": "qa", "dc": "qa", "input_log_server": "localhost", "input_log_port": "20500", "input_log_topic": "crypta@prod@ext-fp--fp-event-delayed-log", "output_log_server": "localhost", "output_log_port": "20500", "output_log_topic": "ext-fp-event-log", "client_id": "lb-consumer", "client_tvm_id": "", "artificial_delay_sec": 1800, "log_dir": "/tmp", "use_secure_tvm": false, "log_level": "trace", "fqdn": "localhost"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

DATA(
    arcadia/crypta/ext_fp/delay_line/bundle/templates/config.yaml
)

DEPENDS(
    crypta/utils/render_and_check_yaml
)

END()
