#pragma once

#include <crypta/ext_fp/common/log_parsers/fp_event_log_parser.h>
#include <crypta/ext_fp/common/unprocessed_queue/unprocessed_queue.h>
#include <crypta/ext_fp/delay_line/lib/config/parser_config.pb.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/pqlib/cookie_queue.h>
#include <crypta/lib/native/sampler/rest_sampler.h>

#include <util/generic/vector.h>

namespace NCrypta::NExtFp::NDelayLine {
    class TParser {
        using TLogParser = TFpEventLogParser;
        using TParsedLine = TLogParser::TParsedLine;

    public:
        TParser(const TParserConfig& config, NPQ::TCookieQueue& cookiesToCommit, TUnprocessedQueue<TVector<TParsedLine>>& unprocessedQueue, TStats& stats);

        void Parse(NPQ::TConsumer::TReadResult&& readResult);

    private:
        TLogParser::TParsedLines ParseEvents(NPQ::TConsumer::TReadResult&& readResult) const;
        void EnqueueEventsAndWait(TLogParser::TParsedLines&& events);

        const NCrypta::TRestSampler Sampler;
        TDuration ArtificialDelay;

        NPQ::TCookieQueue& CookiesToCommit;
        TUnprocessedQueue<TVector<TParsedLine>>& UnprocessedQueue;

        NLog::TLogPtr Log;
        TStats& Stats;
    };
}
