#pragma once

#include <crypta/ext_fp/common/unprocessed_queue/unprocessed_queue.h>
#include <crypta/ext_fp/delay_line/lib/config/config.pb.h>
#include <crypta/ext_fp/delay_line/lib/config/processor_config.pb.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/pqlib/producer.h>
#include <crypta/lib/native/thread/threaded.h>
#include <crypta/lib/proto/ext_fp/fp_event.pb.h>

#include <library/cpp/retry/retry.h>

#include <util/generic/deque.h>

namespace NCrypta::NExtFp::NDelayLine {
    class TProcessor : public TThreaded {
        using TEvent = NCrypta::NExtFp::TFpEvent;
        using TUnprocessedEvents = TUnprocessed<TVector<TEvent>>;
        using TBatch = TVector<TUnprocessed<TVector<TEvent>>>;

    public:
        TProcessor(
                TUnprocessedQueue<TVector<TEvent>>& unprocessedQueue,
                const TProcessorConfig& config,
                NPQ::TProducer& extFpEventLogProducer,
                TStats& stats
         );

        void Run() override;

        ~TProcessor();
    private:
        void EnqueueBatch(TBatch& batch);
        ui32 DequeueEvents(TBatch& batch);
        void RequestSuccess(TBatch& handlers);

        TUnprocessedQueue<TVector<TEvent>>& UnprocessedQueue;

        const TProcessorConfig& Config;
        const TDuration MaxBatchingTime;

        NPQ::TProducer& ExtFpEventLogProducer;

        NLog::TLogPtr Log;
        TStats& Stats;
    };
}
