EXECTEST()

OWNER(
    g:crypta
    g:crypta-ext-fp
)

RUN(
    NAME stable_config
    CWD ${ARCADIA_ROOT}/crypta/ext_fp/matcher/bundle/templates

    render_and_check_yaml
        --template config.yaml
        --output ${TEST_CASE_ROOT}/output.yaml
        --context '{"environment": "production", "dc": "sas", "fqdn": "localhost"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME testing_config
    CWD ${ARCADIA_ROOT}/crypta/ext_fp/matcher/bundle/templates

    render_and_check_yaml
        --template config.yaml
        --output ${TEST_CASE_ROOT}/output.yaml
        --context '{"environment": "testing", "dc": "sas", "fqdn": "localhost"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME qa_config
    CWD ${ARCADIA_ROOT}/crypta/ext_fp/matcher/bundle/templates

    render_and_check_yaml
        --template config.yaml
        --output ${TEST_CASE_ROOT}/output.yaml
        --context '{"environment": "qa", "dc": "qa", "input_log_server": "localhost", "input_log_port": "20500", "fp_event_log_topic": "crypta@prod@ext-fp--fp-event-log", "ext_fp_match_log_server": "localhost", "ext_fp_match_log_port": "20500", "ext_fp_match_log_topic": "ext-fp-match-log", "client_id": "lb-consumer", "client_tvm_id": "", "log_dir": "/tmp", "use_secure_tvm": false, "log_level": "trace", "fqdn": "localhost", "beeline_api_url": "beeline:8888", "beeline_api_use_authentication": false, "ertelecom_api_url": "localhost:8888", "ertelecom_api_use_authentication": false, "mts_api_url": "localhost:7777", "mts_use_authentication": false, "ext_fp_max_events_per_batch": 1, "rostelecom_api_url": "[64:ff9b::1020:3040]:9999", "intentai_api_use_authentication": false, "intentai_api_url": "intentai:2222", "prefiltered_source_ids": ["ertelecom", "mts", "rostelecom", "fake_one"]}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

DATA(
    arcadia/crypta/ext_fp/matcher/bundle/templates/config.yaml
)

DEPENDS(
    crypta/utils/render_and_check_yaml
)

END()
