#include "matcher.h"

using namespace NCrypta;

THolder<NNeh::TResponse> NExtFp::NMatcher::IMatcher::MakeRequest(const TNehSyncMultiClient& client, const NNeh::TMessage& message, const TDuration& timeout, const TString& provider, const TString& requestId, NLog::TLogPtr log) {
    auto resp = client.Request(message, timeout);

    Y_ENSURE(resp.IsOK(), provider << " API call failed: " << resp.GetMessage());
    if (resp.Value()->IsError()) {
        log->error("{} API call failed: {} {}, {}", provider, requestId, resp.Value()->GetErrorCode() , resp.Value()->GetErrorText());
    }
    Y_ENSURE(!resp.Value()->IsError(), provider << " API call failed: " << resp.Value()->GetErrorCode() << " " << resp.Value()->GetErrorText());

    log->info("{} response {} :\n{}", provider, requestId, resp.Value()->Data);

    return std::move(resp).Value();
}
