#pragma once

#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/neh_sync_multi_client/neh_sync_multi_client.h>
#include <crypta/lib/proto/ext_fp/fp_event.pb.h>

#include <util/digest/multi.h>
#include <util/generic/hash.h>
#include <util/generic/string.h>
#include <util/system/types.h>

namespace NCrypta::NExtFp::NMatcher {
    struct TConnection {
        TString Ip;
        ui32 Port;
        ui64 Timestamp;
        TString Domain;

        bool operator==(const TConnection& other) const = default;
    };

    struct TMatchResult {
        enum class EStatus {
            Unknown = -1 /* "unknown" */,
            Found = 0 /* "found" */,
            Expired = 1 /* "expired" */,
            NotFound = 2 /* "not_found" */,
            Error = 3 /* "error" */,
        };

        EStatus Status;
        TString ExtId;

        bool operator==(const TMatchResult& other) const = default;
    };

    using TMatches = THashMap<TConnection, TMatchResult>;

    class IMatcher {
    public:
        virtual ~IMatcher() = default;

        virtual void AddConnection(const TFpEvent&) = 0;
        virtual TMatches GetMatches() = 0;
        static THolder<NNeh::TResponse> MakeRequest(const TNehSyncMultiClient& client, const NNeh::TMessage& message, const TDuration& timeout, const TString& provider, const TString& requestId, NLog::TLogPtr log);
    };
}

template <>
struct THash<NCrypta::NExtFp::NMatcher::TConnection> {
    size_t operator()(const NCrypta::NExtFp::NMatcher::TConnection& connection) const {
        return MultiHash(connection.Ip, connection.Port, connection.Timestamp, connection.Domain);
    }
};
