#pragma once

#include <crypta/ext_fp/matcher/lib/matchers/base_matcher/matcher.h>
#include <crypta/ext_fp/matcher/lib/matchers/beeline_matcher/config/beeline_matcher_config.pb.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/neh_sync_multi_client/neh_sync_multi_client.h>
#include <crypta/lib/native/stats/stats.h>
#include <crypta/lib/proto/ext_fp/fp_event.pb.h>

#include <library/cpp/neh/neh.h>

#include <util/digest/multi.h>
#include <util/generic/hash.h>
#include <util/generic/string.h>

namespace NCrypta::NExtFp::NMatcher {
    class TBeelineMatcher : public IMatcher {
    public:
        TBeelineMatcher(const TBeelineMatcherConfig& config, const TNehSyncMultiClient& client, TStats& stats, NLog::TLogPtr);

        static TConnection MakeConnection(const TFpEvent& event);

        void AddConnection(const TFpEvent& event) override;
        TMatches GetMatches() override;

    private:
        TString GetApiUrl() const;
        static TString GetRequestBody(const TVector<TConnection>& connections);

        const TBeelineMatcherConfig& Config;
        const TNehSyncMultiClient& Client;
        TVector<TConnection> Connections;
        TStats& Stats;
        NLog::TLogPtr Log;
    };
}
