#include "beeline_response_parser.h"

#include <crypta/ext_fp/matcher/lib/matchers/beeline_matcher/beeline_match.pb.h>
#include <crypta/lib/native/proto_serializer/proto_serializer.h>

#include <library/cpp/json/json_reader.h>

using namespace NCrypta::NExtFp::NMatcher;

TMatches NBeelineResponseParser::Parse(const TString& responseBody) {
    NJson::TJsonValue v;
    ReadJsonTree(responseBody, &v);

    TConnection connection;
    TString extId;
    TMatches matches;

    const auto& matchJsons = v.GetArray();
    for (const auto& matchJson : matchJsons) {
        const auto& beelineMatch = NCrypta::NProtoSerializer::CreateFromJsonValue<TBeelineMatch>(matchJson);
        extId = beelineMatch.GetId();
        connection.Ip = beelineMatch.GetIp();
        connection.Port = beelineMatch.GetPort();
        connection.Timestamp = beelineMatch.GetUnixtime();

        matches[connection] = TMatchResult{.Status = TMatchResult::EStatus::Found, .ExtId = extId};
    }

    return matches;
}
