#include "intentai_response_parser.h"

#include <crypta/ext_fp/matcher/lib/matchers/intentai_matcher/intentai_match.pb.h>
#include <crypta/lib/native/proto_serializer/proto_serializer.h>

#include <library/cpp/json/json_reader.h>

using namespace NCrypta::NExtFp::NMatcher;

TMatches NIntentaiResponseParser::Parse(const TString& responseBody) {
    NJson::TJsonValue v;
    ReadJsonTree(responseBody, &v);

    TConnection connection;
    TString extId;
    TMatches matches;

    const auto& matchJsons = v.GetArray();
    for (const auto& matchJson : matchJsons) {
        const auto& intentaiMatch = NCrypta::NProtoSerializer::CreateFromJsonValue<TIntentaiMatch>(matchJson);

        extId = intentaiMatch.GetUserId();
        if (extId.empty()) {
            continue;
        }

        connection.Ip = intentaiMatch.GetIp();
        connection.Port = intentaiMatch.GetPort();
        connection.Timestamp = intentaiMatch.GetTimestamp();

        matches[connection] = TMatchResult{.Status = TMatchResult::EStatus::Found, .ExtId = extId};
    }

    return matches;
}
