#include "mts_response_parser.h"

#include <crypta/ext_fp/matcher/lib/matchers/mts_matcher/mts_match.pb.h>
#include <crypta/ext_fp/matcher/lib/matchers/mts_matcher/timestamp_helpers.h>
#include <crypta/lib/native/proto_serializer/proto_serializer.h>

#include <library/cpp/json/json_reader.h>

using namespace NCrypta::NExtFp::NMatcher;

namespace {
    const TString MTS_UNKNOWN_ID = "unknown";
    const TString MTS_WRONG_IP = "wrong_ip";
}

TMatches NMtsResponseParser::Parse(const TString& responseBody) {
    NJson::TJsonValue v;
    ReadJsonTree(responseBody, &v);

    TConnection connection;
    TString extId;
    TMatches matches;

    const auto& matchJsons = v.GetArray();
    for (const auto& matchJson : matchJsons) {
        const auto& mtsMatch = NCrypta::NProtoSerializer::CreateFromJsonValue<TMtsMatch>(matchJson);
        extId = mtsMatch.GetId();
        if (extId == MTS_UNKNOWN_ID || extId == MTS_WRONG_IP) {
            continue;
        }

        connection.Ip = mtsMatch.GetIp();
        connection.Port = mtsMatch.GetPort();
        connection.Timestamp = FromMtsTimestamp(mtsMatch.GetTs());

        matches[connection] = TMatchResult{.Status = TMatchResult::EStatus::Found, .ExtId = extId};
    }

    return matches;
}
