#pragma once

#include "processor.h"

#include <crypta/ext_fp/common/log_parsers/fp_event_log_parser.h>
#include <crypta/ext_fp/common/unprocessed_queue/unprocessed_queue.h>
#include <crypta/ext_fp/matcher/lib/config/parser_config.pb.h>
#include <crypta/lib/native/ip_filter/ip_filter.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/pqlib/cookie_queue.h>
#include <crypta/lib/native/sampler/rest_sampler.h>

#include <util/generic/vector.h>

namespace NCrypta::NExtFp::NMatcher {
    class TParser {
        using TLogParser = TFpEventLogParser;
        using TParsedLine = TLogParser::TParsedLine;

    public:
        TParser(const TParserConfig& config, NPQ::TCookieQueue& cookiesToCommit, const TProcessor& processor, TStats& stats);

        void Parse(NPQ::TConsumer::TReadResult&& readResult);

    private:
        bool IsProviderBound(ui64 duid, const TString& ip4, const TString& sourceId) const;

        const NCrypta::TRestSampler Sampler;
        const THashSet<TString> PrefilteredSourceIds;

        NPQ::TCookieQueue& CookiesToCommit;
        const TProcessor& Processor;

        NLog::TLogPtr Log;
        TStats& Stats;
    };
}
