#pragma once

#include <crypta/ext_fp/common/unprocessed_queue/unprocessed_queue.h>
#include <crypta/ext_fp/matcher/lib/config/config.pb.h>
#include <crypta/ext_fp/matcher/lib/config/processor_config.pb.h>
#include <crypta/ext_fp/matcher/lib/matchers/base_matcher/matcher.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/pqlib/producer.h>
#include <crypta/lib/proto/ext_fp/fp_event.pb.h>

#include <library/cpp/retry/retry.h>
#include <yt/yt/core/actions/future.h>
#include <yt/yt/core/concurrency/thread_pool.h>
#include <yt/yt/core/misc/intrusive_ptr.h>

#include <util/generic/deque.h>
#include <util/generic/maybe.h>

namespace NCrypta::NExtFp::NMatcher {
    class TProcessor {
        using TEvent = NCrypta::NExtFp::TFpEvent;
        using TEvents = TVector<TEvent>;
        struct TAllMatches {
            TMatches Beeline;
            TMatches ErTelecom;
            TMatches Intentai;
            TMatches Mts;
            TMatches Rostelecom;
        };

    public:
        TProcessor(
            const TProcessorConfig& config,
            NPQ::TProducer& extFpMatchLogProducer,
            TStats& stats
         );

        NYT::TFuture<void> ProcessMatches(TEvents&& events) const;

    private:
        NYT::TFuture<TMatches> AsyncMatch(IMatcher& matcher, const TString& providerName) const;
        TAllMatches GetMatches(const TEvents& batch) const;
        void AddConnection(const TFpEvent& event, IMatcher& matcher) const;
        void MergeEventsWithMatches(const TEvents& batch, const TAllMatches& matches) const;
        TMaybe<TString> FindExtId(const TConnection& connection, const TMatches& matches, const TString& sourceId) const;

        const TProcessorConfig& Config;
        const TProcessorConfig::TMatcherConfigs& MatcherConfigs;

        NPQ::TProducer& ExtFpMatchLogProducer;

        NLog::TLogPtr Log;
        TStats& Stats;
        NYT::TIntrusivePtr<NYT::NConcurrency::TThreadPool> MatchingThreadPool;
        TNehSyncMultiClient Client;
    };
}
