__metaclass__ = type

import os
import paramiko

from ansible.errors import AnsibleError
from ansible.plugins.lookup import LookupBase
from ansible.module_utils._text import to_text


SECDIST = 'secdist.yandex.net'

ROOT = '/repo/projects/crypta'


class LookupModule(LookupBase):

    def run(self, terms, variables=None, **kwargs):
        try:
            client = paramiko.SSHClient()
            client.set_missing_host_key_policy(paramiko.AutoAddPolicy())
            client.connect(SECDIST)

            transport = client.get_transport()
            sftp = paramiko.SFTPClient.from_transport(transport)
            filename = os.path.join(ROOT, terms[0])
            with sftp.open(filename) as handler:
                return [to_text(handler.read().strip())]
        except IOError as e:
            raise AnsibleError(e)
