package ru.yandex.crypta.graph.api.model.graph;

import ru.yandex.crypta.graph.soup.config.proto.TEdgeUsage;

public class EdgeUsage {

    private boolean yandexSafe;
    private boolean soupUpdate;
    private boolean humanMatching;
    private boolean soupyIndevice;

    public EdgeUsage() {
        yandexSafe = false;
        soupUpdate = false;
        humanMatching = false;
        soupyIndevice = false;
    }

    public EdgeUsage(boolean yandexSafe, boolean soupUpdate, boolean humanMatching, boolean soupyIndevice) {
        this.yandexSafe = yandexSafe;
        this.soupUpdate = soupUpdate;
        this.humanMatching = humanMatching;
        this.soupyIndevice = soupyIndevice;
    }

    public EdgeUsage(TEdgeUsage eu) {
        this.yandexSafe = eu.getYandexSafe();
        this.soupUpdate = eu.getSoupUpdate();
        this.humanMatching = eu.getHumanMatching();
        this.soupyIndevice = eu.getSoupyIndevice();
    }

    public boolean isYandexSafe() {
        return yandexSafe;
    }

    public void setYandexSafe(boolean yandexSafe) {
        this.yandexSafe = yandexSafe;
    }

    public boolean isSoupUpdate() {
        return soupUpdate;
    }

    public void setSoupUpdate(boolean soupUpdate) {
        this.soupUpdate = soupUpdate;
    }

    public boolean isHumanMatching() {
        return humanMatching;
    }

    public void setHumanMatching(boolean humanMatching) {
        this.humanMatching = humanMatching;
    }

    public boolean isSoupyIndevice() {
        return soupyIndevice;
    }

    public void setSoupyIndevice(boolean soupyIndevice) {
        this.soupyIndevice = soupyIndevice;
    }
}
