package ru.yandex.crypta.graph.api.model.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class Embedding {

    private final List<Double> value;

    private Embedding(List<Double> value) {
        this.value = value;
    }

    public static Embedding fromArray(double[] array) {
        var value = new ArrayList<Double>();
        Arrays.stream(array).forEach(value::add);
        return new Embedding(value);
    }

    public static Embedding random2d() {
        var random = new Random();
        return new Embedding(List.of(random.nextGaussian(), random.nextGaussian()));
    }

    public List<Double> getValue() {
        return value;
    }

}
