package ru.yandex.crypta.graph.api.model.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import ru.yandex.crypta.graph.api.model.ids.GraphIdInfo;

public class Graph {
    private List<GraphComponent> graphComponents = new ArrayList<>();
    private List<Edge> edgesBetweenComponents = new ArrayList<>();
    private List<MergeInfo> mergeInfo = new ArrayList<>();
    private Map<String, GraphComponentInfo> componentsInfo = new HashMap<>();
    private List<GraphIdInfo> idsInfo = new ArrayList<>();

    public Graph() {
    }

    public Graph(List<GraphComponent> graphComponents) {
        this.graphComponents = graphComponents;
    }

    public Graph(GraphComponent graphComponent) {
        this.graphComponents.add(graphComponent);
    }

    public Graph(GraphComponentWithInfo componentWithInfo) {
        this.addComponentWithInfo(componentWithInfo);
    }

    public List<GraphComponent> getGraphComponents() {
        return graphComponents;
    }

    public void setGraphComponents(List<GraphComponent> graphComponents) {
        this.graphComponents = graphComponents;
    }

    public List<Edge> getAllEdges() {
        Stream<Edge> innerEdges = this.graphComponents.stream()
                .flatMap(graphComponent -> graphComponent.getEdges().stream());

        Stream<Edge> betweenEdges = this.edgesBetweenComponents.stream();

        return Stream.concat(innerEdges, betweenEdges).collect(Collectors.toList());
    }

    public List<Edge> getEdgesBetweenComponents() {
        return edgesBetweenComponents;
    }

    public void addEdgeBetweenComponents(Edge e) {
        edgesBetweenComponents.add(e);
    }

    public List<MergeInfo> getMergeInfo() {
        return mergeInfo;
    }

    public void setMergeInfo(List<MergeInfo> mergeInfo) {
        this.mergeInfo = mergeInfo;
    }

    public Map<String, GraphComponentInfo> getComponentsInfo() {
        return componentsInfo;
    }

    public void setComponentsInfo(Map<String, GraphComponentInfo> componentsInfo) {
        this.componentsInfo = componentsInfo;
    }

    public List<GraphIdInfo> getIdsInfo() {
        return idsInfo;
    }

    public void setIdsInfo(List<GraphIdInfo> idsInfo) {
        this.idsInfo = idsInfo;
    }

    public void addComponentWithInfo(GraphComponentWithInfo info) {
        graphComponents.add(info.getComponent());
        edgesBetweenComponents.addAll(info.getEdgesBetweenComponents());
        if (info.getComponentsInfo() != null) {
            componentsInfo.put(info.getComponent().getCryptaId(), info.getComponentsInfo());
        }
        idsInfo.addAll(info.getIdsInfo());
        mergeInfo.addAll(info.getMergeInfo());
    }

    public void addComponent(GraphComponent component) {
        graphComponents.add(component);
    }

    public void setEdgesBetweenComponents(List<Edge> edgesBetweenComponents) {
        this.edgesBetweenComponents = edgesBetweenComponents;
    }

    @Override
    public String toString() {
        return "Graph{" +
                "graphComponents=" + graphComponents +
                ", edgesBetweenComponents=" + edgesBetweenComponents +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Graph)) {
            return false;
        }
        Graph graph = (Graph) o;
        return Objects.equals(graphComponents, graph.graphComponents);
    }

    @Override
    public int hashCode() {
        return Objects.hash(graphComponents);
    }

}
