package ru.yandex.crypta.graph.api.model.graph;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.function.Function;

public class GraphComponent {

    private String cryptaId;
    private List<Vertex> vertices;
    private List<Edge> edges;

    public GraphComponent(String cryptaId, List<Vertex> vertices, List<Edge> edges) {
        this.cryptaId = cryptaId;
        this.vertices = vertices;
        this.edges = edges;
    }

    public static Set<Vertex> verticesOfEdges(Collection<Edge> edges) {
        HashSet<Vertex> vertices = new HashSet<>();
        for (Edge edge : edges) {
            vertices.add(new Vertex(edge.getId1(), edge.getId1Type()));
            vertices.add(new Vertex(edge.getId2(), edge.getId2Type()));
        }
        return vertices;
    }

    public String getCryptaId() {
        return cryptaId;
    }

    public List<Vertex> getVertices() {
        return vertices;
    }

    public GraphComponent mapVertices(Function<Vertex, Vertex> mapper) {
        vertices = Cf.x(vertices).map(mapper);
        return this;
    }

    public List<Edge> getEdges() {
        return edges;
    }

    public GraphComponent mapEdges(Function<Edge, Edge> mapper) {
        edges = Cf.x(edges).map(mapper);
        return this;
    }

    @Override
    public String toString() {
        return "GraphComponent{" +
                "cryptaId=" + cryptaId +
                ", vertices=" + vertices +
                ", edges=" + edges +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GraphComponent)) {
            return false;
        }
        GraphComponent component = (GraphComponent) o;
        return Objects.equals(vertices, component.vertices) &&
                Objects.equals(edges, component.edges);
    }

    @Override
    public int hashCode() {
        return Objects.hash(vertices, edges);
    }

}
