package ru.yandex.crypta.graph.api.model.graph;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.crypta.graph.api.model.ids.GraphId;
import ru.yandex.crypta.graph2.model.matching.score.MetricsTree;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;


public class GraphComponentInfo {
    private String cryptaId;
    private GraphId mainId;
    private int verticesCount;
    private int neighboursCount;
    private MetricsTree metricsTree;

    public GraphComponentInfo(String cryptaId, GraphId mainId, int verticesCount, int neighboursCount,
                              MapF<String, YTreeNode> score) {
        this.cryptaId = cryptaId;
        this.mainId = mainId;
        this.verticesCount = verticesCount;
        this.neighboursCount = neighboursCount;

        MapF<String, Double> children = Cf.wrap(score.getO("children")
                .get()
                .asMap())
                .entries()
                .map2(YTreeNode::doubleValue)
                .toMap();
        this.metricsTree = new MetricsTree(score.getO("score").get().doubleValue(), children);
    }

    public GraphComponentInfo(String cryptaId, GraphId mainId, int verticesCount, int neighboursCount,
                              MetricsTree metricsTree) {
        this.cryptaId = cryptaId;
        this.mainId = mainId;
        this.verticesCount = verticesCount;
        this.neighboursCount = neighboursCount;
        this.metricsTree = metricsTree;
    }

    public String getCryptaId() {
        return cryptaId;
    }

    public GraphId getMainId() {
        return mainId;
    }

    public int getVerticesCount() {
        return verticesCount;
    }

    public int getNeighboursCount() {
        return neighboursCount;
    }

    public MetricsTree getMetricsTree() {
        return metricsTree;
    }
}
