package ru.yandex.crypta.graph.api.model.graph;

import java.util.Collections;
import java.util.List;

import ru.yandex.crypta.graph.api.model.ids.GraphIdInfo;

public class GraphComponentWithInfo {
    private GraphComponent component;
    private List<Edge> edgesBetweenComponents = Collections.emptyList();
    private List<MergeInfo> mergeInfo = Collections.emptyList();
    private GraphComponentInfo componentsInfo;
    private List<GraphIdInfo> idsInfo = Collections.emptyList();

    public GraphComponentWithInfo(GraphComponent component) {
        this.component = component;
    }

    public GraphComponent getComponent() {
        return component;
    }

    public List<Edge> getEdgesBetweenComponents() {
        return edgesBetweenComponents;
    }

    public void setEdgesBetweenComponents(List<Edge> edgesBetweenComponents) {
        this.edgesBetweenComponents = edgesBetweenComponents;
    }

    public GraphComponentInfo getComponentsInfo() {
        return componentsInfo;
    }

    public void setComponentsInfo(GraphComponentInfo componentsInfo) {
        this.componentsInfo = componentsInfo;
    }

    public List<GraphIdInfo> getIdsInfo() {
        return idsInfo;
    }

    public void setIdsInfo(List<GraphIdInfo> idsInfo) {
        this.idsInfo = idsInfo;
    }

    public List<MergeInfo> getMergeInfo() {
        return mergeInfo;
    }

    public void setMergeInfo(List<MergeInfo> mergeInfo) {
        this.mergeInfo = mergeInfo;
    }

    public boolean isEmpty() {
        return component.getVertices().isEmpty() && idsInfo.isEmpty();
    }
}
