package ru.yandex.crypta.graph.api.model.graph;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.crypta.graph2.model.matching.component.similarity.SimilarityResult;
import ru.yandex.crypta.graph2.model.matching.score.MetricsTree;
import ru.yandex.inside.yt.kosher.ytree.YTreeNode;

public class MergeInfo {
    private String mergeKey;
    private String status;
    private String strength;
    private Double weight;
    private MetricsTree scoreGain = null;
    private List<SimilarityResult> similarityResults;

    public MergeInfo(String mergeKey, String status, String strength, Double weight, MapF<String,
            YTreeNode> scoreGain, ListF<YTreeNode> similarityResults) {
        this.mergeKey = mergeKey;
        this.status = status;
        this.strength = strength;
        this.weight = weight;

        if (scoreGain.isNotEmpty()) {
            MapF<String, Double> children = Cf.wrap(scoreGain.get("children").asMap())
                    .entries()
                    .map2(YTreeNode::doubleValue)
                    .toMap();

            this.scoreGain = new MetricsTree(
                    scoreGain.getO("score").get().doubleValue(),
                    children
            );
        }

        this.similarityResults = similarityResults.stream().map(
                s -> {
                    Map<String, YTreeNode> m = s.asMap();
                    return new SimilarityResult(
                            m.get("isSimilar").boolValue(),
                            m.get("similarityType").stringValue()
                    );
                }
        ).collect(Collectors.toList());
    }

    public MergeInfo(String mergeKey, String status, String strength, Double weight, MetricsTree scoreGain,
                     List<SimilarityResult> similarityResults) {
        this.mergeKey = mergeKey;
        this.status = status;
        this.strength = strength;
        this.weight = weight;
        this.scoreGain = scoreGain;
        this.similarityResults = similarityResults;
    }

    public String getMergeKey() {
        return mergeKey;
    }

    public String getStatus() {
        return status;
    }

    public String getStrength() {
        return strength;
    }

    public Double getWeight() {
        return weight;
    }

    public MetricsTree getScoreGain() {
        return scoreGain;
    }

    public List<SimilarityResult> getSimilarityResults() {
        return similarityResults;
    }
}
