package ru.yandex.crypta.graph.api.model.graph;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonInclude;

import ru.yandex.crypta.graph.api.model.ids.GraphId;
import ru.yandex.crypta.graph.api.utils.ExportableVertex;

public class Vertex implements ExportableVertex {

    private String idValue;
    private String idType;
    private GraphElementStatus status = GraphElementStatus.NOT_CHANGED;
    private Embedding embedding;
    private int overlimitCount;

    public Vertex(String idValue, String idType) {
        this.idValue = idValue;
        this.idType = idType;
    }

    public int getOverlimitCount() {
        return overlimitCount;
    }

    public void setOverlimitCount(int overlimitCount) {
        this.overlimitCount = overlimitCount;
    }

    public void setAddedStatus() {
        this.status = GraphElementStatus.ADDED;
    }

    public void setRemovedStatus() {
        this.status = GraphElementStatus.REMOVED;
    }

    @Override
    public String getIdValue() {
        return idValue;
    }

    @Override
    public String getIdType() {
        return idType;
    }

    public GraphId toId() {
        return new GraphId(idValue, idType);
    }

    @Override
    public String getFullId() {
        String fullId = toId().repr();
        if (overlimitCount != 0) {
            fullId += "_HUGE";
        }
        return fullId;
    }

    public GraphElementStatus getStatus() {
        return status;
    }

    @JsonInclude(value = JsonInclude.Include.NON_NULL)
    public Embedding getEmbedding() {
        return embedding;
    }

    @Override
    public String getColor() {
        return status.getColor();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Vertex)) {
            return false;
        }
        Vertex vertex = (Vertex) o;
        return Objects.equals(idValue, vertex.idValue) &&
                Objects.equals(idType, vertex.idType);
    }

    @Override
    public int hashCode() {

        return Objects.hash(idValue, idType);
    }

    @Override
    public String toString() {
        return getFullId();
    }

    public Vertex withEmbedding(Embedding embedding) {
        this.embedding = embedding;
        return this;
    }
}
