package ru.yandex.crypta.graph.api.model.graph;

public class VertexWithLevel {
    private VertexMayBeTerminal vertex;
    private int level;

    public VertexWithLevel(VertexMayBeTerminal vertex, int level) {
        this.vertex = vertex;
        this.level = level;
    }

    public Vertex getVertex() {
        return vertex;
    }

    public int getLevel() {
        return level;
    }

    public boolean isVertexTerminal() {
        return vertex.isTerminal();
    }

    public void setVertexTerminal(boolean isTerminal) {
        vertex.setIsTerminal(isTerminal);
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof VertexWithLevel)) {
            return false;
        }

        VertexWithLevel otherVertexWithLevel = (VertexWithLevel) other;

        return vertex.equals(otherVertexWithLevel.vertex);
    }

    @Override
    public int hashCode() {
        return vertex.hashCode();
    }
}
