package ru.yandex.crypta.graph.api.model.ids;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

import ru.yandex.crypta.graph.api.model.graph.Vertex;
import ru.yandex.crypta.graph.soup.config.Soup;
import ru.yandex.crypta.lib.proto.identifiers.EIdType;

public class GraphId {

    public static final String CRYPTA_ID_TYPE = Soup.CONFIG.name(EIdType.CRYPTA_ID);
    public static final String OLD_CRYPTA_ID_TYPE = Soup.CONFIG.name(EIdType.CRYPTA_ID1);
    public static final String HOUSEHOLD_ID_TYPE = "hhid";
    public static final String PRIVATE_YANDEXUID_TYPE = Soup.CONFIG.name(EIdType.PRIVATE_YANDEXUID);
    public static final String YANDEXUID_TYPE = Soup.CONFIG.name(EIdType.YANDEXUID);
    public static final String OLD_DEVICE_ID = Soup.CONFIG.name(EIdType.OLD_DEVICE_ID);
    public static final String PUID_TYPE = Soup.CONFIG.name(EIdType.PUID);
    public static final String MERGE_KEY = "merge_key";

    private String idValue;
    private String idType;

    public GraphId(String idValue, String idType) {
        this.idValue = idValue;
        this.idType = idType;
    }

    public String getIdValue() {
        return idValue;
    }

    public String getIdType() {
        return idType;
    }

    public List<String> toKey() {
        return Arrays.asList(idValue, idType);
    }

    public Vertex toVertex() {
        return new Vertex(idValue, idType);
    }

    public static GraphId fromVertex(Vertex vertex) {
        return new GraphId(vertex.getIdValue(), vertex.getIdType());
    }

    public List<String> toIdTypeKey() {
        return Arrays.asList(idType, idValue);
    }

    public String repr() {
        return idValue + "(" + idType.toUpperCase() + ")";
    }

    public boolean isCryptaId() {
        return idType.equals(CRYPTA_ID_TYPE) || idType.equals(OLD_CRYPTA_ID_TYPE);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GraphId)) {
            return false;
        }
        GraphId graphId = (GraphId) o;
        return Objects.equals(idValue, graphId.idValue) &&
                Objects.equals(idType, graphId.idType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(idValue, idType);
    }

    @Override
    public String toString() {
        return repr();
    }
}
