package ru.yandex.crypta.graph.api.model.ids;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

import com.fasterxml.jackson.databind.JsonNode;

public class GraphIdInfo {
    private GraphId id;

    private Map<String, JsonNode> info = new HashMap<>();

    public GraphIdInfo(GraphId id) {
        this.id = id;
    }

    public GraphIdInfo(GraphId id, Map<String, JsonNode> info) {
        this.id = id;
        this.info = info;
    }

    public GraphId getId() {
        return id;
    }

    public Map<String, JsonNode> getInfo() {
        return info;
    }

    public GraphIdInfo addInfoRec(Map<String, JsonNode> infoRec) {
        infoRec.entrySet().stream()
                .filter(each -> !each.getValue().isNull())
                .forEach(each -> info.put(each.getKey(), each.getValue()));
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GraphIdInfo)) {
            return false;
        }
        GraphIdInfo that = (GraphIdInfo) o;
        return Objects.equals(id, that.id);
    }

    @Override
    public int hashCode() {

        return Objects.hash(id);
    }
}
