package ru.yandex.crypta.graph.api.service;

import java.util.Optional;

import ru.yandex.crypta.graph.api.model.graph.Graph;
import ru.yandex.crypta.graph.api.model.ids.GraphId;
import ru.yandex.crypta.graph.api.service.settings.GraphSettings;
import ru.yandex.crypta.graph.api.service.settings.model.InfoParams;
import ru.yandex.crypta.graph.api.service.settings.model.SearchParams;

public interface GraphService {

    Optional<Graph> getById(GraphId id, SearchParams params, InfoParams infoParams);

    default Optional<Graph> getById(GraphId id) {
        return getById(id, SearchParams.DEFAULT, InfoParams.DEFAULT);
    }

    GraphSettings getGraphSettings();

}
