package ru.yandex.crypta.graph.api.service;

import java.util.List;
import java.util.Optional;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.crypta.graph.api.model.graph.Edge;
import ru.yandex.crypta.graph.api.model.graph.Graph;
import ru.yandex.crypta.graph.api.model.graph.GraphComponent;
import ru.yandex.crypta.graph.api.model.graph.Vertex;
import ru.yandex.crypta.graph.api.model.ids.GraphId;
import ru.yandex.crypta.graph.api.service.settings.GraphSettings;
import ru.yandex.crypta.graph.api.service.settings.model.InfoParams;
import ru.yandex.crypta.graph.api.service.settings.model.SearchParams;

public class StubGraphService implements GraphService {

    @Override
    public Optional<Graph> getById(GraphId id, SearchParams params, InfoParams infoParams) {
        Vertex v1 = new Vertex("v1", "type1");
        Vertex v2 = new Vertex("v2", "type1");
        Vertex v3 = new Vertex("v3", "type2");

        Vertex v4 = new Vertex("v4", "type1");
        Vertex v5 = new Vertex("v5", "type2");

        Graph graph = new Graph(Cf.list(
                new GraphComponent(
                        "c1",
                        Cf.list(v1, v2, v3),
                        Cf.list(
                                new Edge(
                                        v1, v2,
                                        "st1", "ls1", 0.0, Cf.list()
                                ),
                                new Edge(
                                        v1, v3,
                                        "st1", "ls1", 0.0, Cf.list()
                                ),
                                new Edge(
                                        v2, v3,
                                        "st2", "ls1", 0.0, Cf.list()
                                )
                        )
                ),
                new GraphComponent(
                        "c2",
                        Cf.list(v4, v5),
                        Cf.list(
                                new Edge(
                                        v4.getIdValue(), v4.getIdType(),
                                        v5.getIdValue(), v5.getIdType(),
                                        "st1", "ls1", 0.0, Cf.list())
                        )
                )
        ));
        graph.addEdgeBetweenComponents(new Edge(
                v1.getIdValue(), v1.getIdType(),
                v4.getIdValue(), v4.getIdType(),
                "st1", "ls1", 0.0, Cf.list()));
        return Optional.of(graph);
    }

    @Override
    public GraphSettings getGraphSettings() {
        return new GraphSettings() {
            @Override
            public List<String> getSupportedMatchTypes() {
                return Cf.list("v2_prod_yt");
            }

            @Override
            public List<String> getSupportedScopes() {
                return Cf.list("xxx", "neighbours");
            }

            @Override
            public List<String> getSupportedIdTypes() {
                return Cf.list("type1");
            }
        };
    }
}
