package ru.yandex.crypta.graph.api.service.settings;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.misc.lang.Check;

public class YtAntifraudSoupGraphSettings implements SoupGraphSettings {

    public static final List<String> MATCH_TYPES = List.of("antifraud");

    public static final Map<String, YPath> MATCH_SCOPE_TABLES = Map.of(
            "all", YPath.simple("//home/antifraud/export/glue/soup/antifraud_dyn"),
            "market", YPath.simple("//home/antifraud/export/glue/soup/market_dyn"),
            "uslugi", YPath.simple("//home/antifraud/export/glue/soup/uslugi_dyn"),
            "direct", YPath.simple("//home/antifraud/export/glue/soup/direct_dyn")
    );

    public static final List<String> MATCH_SCOPES = new ArrayList<>(MATCH_SCOPE_TABLES.keySet());

    private static final List<String> ANTIFRAUD_ID_TYPES = List.of(
            "puid",
            "yandexuid",
            "uuid",
            "crypta_id",
            "card_id",
            "shop_id",
            "ogrn",
            "inn",
            "phone",
            "email",
            "login",
            "client_id",
            "page_id",
            "partner_id",
            "domain",
            "domain_hash",
            "passport_number_hash"
    );

    @Override
    public List<String> getSupportedMatchTypes() {
        return MATCH_TYPES;
    }

    @Override
    public List<String> getSupportedScopes() {
        return MATCH_SCOPES;
    }

    @Override
    public List<String> getSupportedIdTypes() {
        return ANTIFRAUD_ID_TYPES;
    }

    @Override
    public YPath getSoupTable(String matchScope) {
        Check.isTrue(MATCH_SCOPES.contains(matchScope), () -> "matchScope is not supported: " + matchScope);
        return MATCH_SCOPE_TABLES.get(matchScope);
    }

    @Override
    public int getEdgesLimit() {
        return 2000;
    }
}
