package ru.yandex.crypta.graph.api.service.settings;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import ru.yandex.crypta.graph.api.model.ids.GraphId;
import ru.yandex.crypta.graph.soup.config.Soup;
import ru.yandex.crypta.lib.proto.identifiers.EIdType;
import ru.yandex.crypta.lib.yt.YtReadingUtils;
import ru.yandex.inside.yt.kosher.cypress.YPath;

public class YtGraphEngineSettings implements GraphSettings {
    private static final List<String> MATCH_TYPES = List.of("graph_engine");
    private static final List<String> SCOPES = List.of(
            "example"
    );

    public static final List<String> ID_TYPES = Stream.concat(
            Stream.of(
                    GraphId.MERGE_KEY,
                    Soup.CONFIG.name(EIdType.CRYPTA_ID)
            ),
            YtSoupGraphSettings.ID_TYPES.stream()
    ).collect(Collectors.toList());

    private static final GraphEnginePaths PATHS = new GraphEnginePaths(
            "//home/crypta/production/state/graph/v2/matching/workdir"
    );

    @Override
    public List<String> getSupportedMatchTypes() {
        return MATCH_TYPES;
    }

    @Override
    public List<String> getSupportedScopes() {
        return SCOPES;
    }

    @Override
    public List<String> getSupportedIdTypes() {
        return ID_TYPES;
    }

    public GraphEnginePaths getPaths() {
        return PATHS;
    }

    public static class GraphEnginePaths {

        private YPath basePath;

        GraphEnginePaths(String absolutePath) {
            basePath = YPath.simple(absolutePath);
        }

        public YPath byId(GraphId graphId) {
            return basePath.child("output").child("vertices_no_multi_profile")
                    .withExact(YtReadingUtils.exact(graphId.toKey()));
        }

        public YPath byCryptaId(String id) {
            return basePath.child("output").child("components_by_crypta_id")
                    .withExact(YtReadingUtils.exact(id));
        }

        public YPath byMergeKey(String mergeKey) {
            return basePath.child("prepare").child("components_by_merge_key")
                    .withExact(YtReadingUtils.exact(mergeKey));
        }

        public YPath edgesBetweenByMergeKey(String mergeKey) {
            return basePath.child("init").child("soup_edges_between_components_by_merge_key")
                    .withExact(YtReadingUtils.exact(mergeKey));
        }
    }
}
