package ru.yandex.crypta.graph.api.service.settings;

import java.util.List;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph.api.model.ids.GraphId;
import ru.yandex.crypta.graph.soup.config.Soup;
import ru.yandex.crypta.lib.proto.identifiers.EIdType;
import ru.yandex.crypta.lib.yt.YtReadingUtils;
import ru.yandex.inside.yt.kosher.cypress.YPath;

public class YtHouseholdsGraphSettings implements GraphSettings {

    private static final ListF<String> MATCH_TYPES = Cf.list("households");
    private static final ListF<String> MATCH_SCOPES = Cf.list(GraphId.HOUSEHOLD_ID_TYPE);
    private static final ListF<String> ID_TYPES = Cf.list(
            Soup.CONFIG.name(EIdType.YANDEXUID),
            // GraphId.CRYPTA_ID_TYPE,
            GraphId.HOUSEHOLD_ID_TYPE
    );

    private HouseholdsGraphPaths paths = new HouseholdsGraphPaths(
            "//home/crypta/production/state/households_new/output"
    );

    @Override
    public List<String> getSupportedMatchTypes() {
        return MATCH_TYPES;
    }

    @Override
    public List<String> getSupportedScopes() {
        return MATCH_SCOPES;
    }

    @Override
    public List<String> getSupportedIdTypes() {
        return ID_TYPES;
    }

    public HouseholdsGraphPaths getPaths() {
        return paths;
    }

    public static class HouseholdsGraphPaths {

        private YPath basePath;

        HouseholdsGraphPaths(String absolutePath) {
            basePath = YPath.simple(absolutePath);
        }

        public YPath getReversedPath(GraphId graphId) {
            return basePath.child("hh_reversed")
                    .withExact(YtReadingUtils.exact(graphId.getIdValue()));
        }

        public YPath getEnrichPath(String hhId) {
            return basePath.child("hh_enrich")
                    .withExact(YtReadingUtils.exact(hhId));
        }
    }
}
