package ru.yandex.crypta.graph.api.service.settings;

import java.util.List;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph.soup.config.Soup;
import ru.yandex.crypta.lib.proto.identifiers.EIdType;
import ru.yandex.inside.yt.kosher.cypress.YPath;

public class YtProtoExportGraphSettings implements GraphSettings {

    public static final YPath OK_PATH = YPath.simple("//home/crypta/production/state/graph/v2/export/graphs");
    public static final YPath ERRORS_PATH = YPath.simple("//home/crypta/production/state/graph/v2/export/rejected");
    public static final String BASIC_MATCH_SCOPE = "basic";
    public static final String SPANNING_MATCH_SCOPE = "spanning";
    public static final String ERRORS_MATCH_SCOPE = "errors";
    private static final ListF<String> MATCH_TYPES = Cf.list("v2_export");
    private static final ListF<String> SCOPES = Cf.list(BASIC_MATCH_SCOPE, SPANNING_MATCH_SCOPE, ERRORS_MATCH_SCOPE);
    private static final ListF<String> ID_TYPES = Cf.list(Soup.CONFIG.name(EIdType.CRYPTA_ID));

    @Override
    public List<String> getSupportedMatchTypes() {
        return MATCH_TYPES;
    }

    @Override
    public List<String> getSupportedScopes() {
        return SCOPES;
    }

    @Override
    public List<String> getSupportedIdTypes() {
        return ID_TYPES;
    }
}
