package ru.yandex.crypta.graph.api.service.settings;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import ru.yandex.crypta.graph.api.model.ids.GraphId;
import ru.yandex.crypta.graph.soup.config.Soup;
import ru.yandex.crypta.lib.proto.identifiers.EIdType;
import ru.yandex.inside.yt.kosher.cypress.YPath;

public class YtRTGraphEngineSettings implements GraphSettings {
    public static final String PROD = "rt_graph_engine";
    public static final String TESTING = "rt_graph_engine_testing";
    private static final List<String> MATCH_TYPES = List.of(
            TESTING,
            PROD
    );
    private static final List<String> SCOPES = List.of(
            "example"
    );

    public static final List<String> ID_TYPES = Stream.concat(
            Stream.of(
                    GraphId.MERGE_KEY,
                    Soup.CONFIG.name(EIdType.CRYPTA_ID)
            ),
            YtSoupGraphSettings.ID_TYPES.stream()
    ).collect(Collectors.toList());

    @Override
    public List<String> getSupportedMatchTypes() {
        return MATCH_TYPES;
    }

    @Override
    public List<String> getSupportedScopes() {
        return SCOPES;
    }

    @Override
    public List<String> getSupportedIdTypes() {
        return ID_TYPES;
    }

    public YPath getMichurinStatePath(String matchType) {
        if (PROD.equals(matchType)) {
            return YPath.simple("//home/crypta/production/rtsklejka/state/michurin_state");
        } else if (TESTING.equals(matchType)) {
            return YPath.simple("//home/crypta/testing/rtsklejka/state/michurin_state");
        }
        throw new IllegalStateException("Match type is not supported");
    }

    public YPath getCryptaIdIndexPath(String matchType) {
        if (PROD.equals(matchType)) {
            return YPath.simple("//home/crypta/production/rtsklejka/state/cryptaid_state");
        } else if (TESTING.equals(matchType)) {
            return YPath.simple("//home/crypta/testing/rtsklejka/state/cryptaid_state");
        }
        throw new IllegalStateException("Match type is not supported");
    }


}
