package ru.yandex.crypta.graph.api.service.settings;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import ru.yandex.crypta.graph.soup.config.Soup;
import ru.yandex.inside.yt.kosher.cypress.YPath;

import static java.util.stream.Collectors.toSet;

public class YtSoupGraphSettings implements SoupGraphSettings {

    public static final YPath TABLE = YPath.simple(
            "//home/crypta/production/state/graph/v2/soup/cooked/soup_edges_backwards"
    );

    private static final List<String> MATCH_TYPES = List.of("soup");

    public static final List<String> ID_TYPES = Soup.CONFIG
            .getEdgeTypes()
            .stream()
            .filter(
                    et -> Soup.CONFIG.getEdgeUsage(et).getHumanMatching() ||
                            Soup.CONFIG.getEdgeUsage(et).getHumanMatchingExp() ||
                            Soup.CONFIG.getEdgeUsage(et).getSoupUpdate())
            .flatMap(et -> Stream.of(et.getId1Type(), et.getId2Type()))
            .map(Soup.CONFIG::name)
            .filter(Objects::nonNull)
            .collect(toSet())
            .stream()
            .sorted()
            .collect(Collectors.toList());

    @Override
    public List<String> getSupportedMatchTypes() {
        return MATCH_TYPES;
    }

    @Override
    public List<String> getSupportedScopes() {
        return List.of();
    }

    @Override
    public List<String> getSupportedIdTypes() {
        return ID_TYPES;
    }

    @Override
    public YPath getSoupTable(String matchScope) {
        return TABLE;
    }

    @Override
    public int getEdgesLimit() {
        return 200;
    }
}
